#extension GL_EXT_draw_buffers : enable

precision mediump float;

uniform sampler2D 	texture_diffuse;
uniform sampler2D 	texture_normal;
uniform vec4 		uniform_colour;

varying vec2 v_uv;

void main()
{
    // Fetch Fragments Normal + Diffuse textures
    vec4 normal  = texture2D( texture_normal, v_uv);
    vec4 diffuse = texture2D( texture_diffuse, v_uv) * uniform_colour;

    // Write to albedo+normal buffers
    gl_FragData[0] = diffuse;
    gl_FragData[1] = vec4(0.5, 0.5, 1.0, diffuse.w);
}
